library IEEE;
use IEEE.std_logic_1164.all;

entity ROM16x8 is
port (address : in INTEGER range 0 to 15;
      data : out std_logic_vector (7 downto 0));
end entity ROM16x8;

architecture kvadrator of ROM16x8 is
type rom_array is array (0 to 15) of std_logic_vector (7 downto 0);
constant rom : rom_array := 
    ("00000000","00000001",
     "00000100","00001001",
     "00010000","00011001",
     "00100100","00110001",
     "01000000","01010001",
     "01100100","01111001",
     "10010000","10101001",
     "11000100","11100001");
     begin
         data <= rom(address);
end architecture kvadrator;
